//
//  NSMutableDictionary+MCAdditions.h
//  MCFoundation
//
//  Created by Michael Clark on Tue Sep 17 2002.
//  Copyright (c) 2002 __MyCompanyName__. All rights reserved.
//

#import <Foundation/Foundation.h>


@interface NSMutableDictionary (MCAdditions) 

// These methods assume that the keys will all be NSStrings - if you try to use something else it will crash
+ (NSMutableDictionary*)mcCaseInsensitiveKeyDictionary;
+ (NSMutableDictionary*)mcCaseInsensitiveKeyDictionaryWithCapacity: (unsigned int)numItems;

- (void)setOrRemoveObject:(id)obj forKey:(id)key;

- (void)conditionallySetObject: (id)obj forKey: (id)key;
- (void)conditionallySetObjectOrNSNullIfEmpty:(id)obj forKey:(id)key;

- (void)setObject:(id)anObject forKeys:(NSArray *)keys;

// These are nice for ease of use
- (void)setFloatValue:(float)value forKey:(id)key;
- (void)setDoubleValue:(double)value forKey:(id)key;
- (void)setIntValue:(int)value forKey:(id)key;
- (void)setBoolValue:(BOOL)value forKey:(id)key;

// Setting with defaults
- (void)setObject:(id)object forKey:(id)key defaultObject:(id)defaultObject;
- (void)setFloatValue:(float)value forKey:(id)key defaultValue:(float)defaultValue;
- (void)setDoubleValue:(double)value forKey:(id)key defaultValue:(double)defaultValue;
- (void)setIntValue:(int)value forKey:(id)key defaultValue:(int)defaultValue;
- (void)setBoolValue:(BOOL)value forKey:(id)key defaultValue:(BOOL)defaultValue;

- (void)replaceDateValuesWithCalendarDateValues;

/* looks for strings in mutable dictionaries values (including nested dicts), unravells the delimiters, then calls valueForKeyPath with the resulting string and replace the string with what it gets from aDict. Delimiters MUST be at the beginning and end of the string -  <$myObject.mySelector.myOtherObject$>

array or dict as root
	key = <$myObject.date$>
	key2 = array
				array
					dict
						key = <$myObject.date$>

*/
- (void)performSubstitutionWith:(NSDictionary *)aDict inStringValuesWithStartDelimiter:(NSString *)startDelim endDelimiter:(NSString *)endDelim;

- (void)takeMissingEntriesFromDictionary:(NSDictionary *)otherDict;

@end
